% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_stratified_analysis_sc.R
\name{sex_stratified_analysis_sc}
\alias{sex_stratified_analysis_sc}
\title{Compute sex-specific differentially expressed genes (DEGs)}
\usage{
sex_stratified_analysis_sc(
  seurat_obj,
  sex_column = "sex",
  phenotype_column = "status",
  celltype_column = "cell_type",
  sex_labels_vector = c("F", "M"),
  min_logfc = 0.25,
  phenotype_labels_vector = c("WT", "TG"),
  method = "wilcox"
)
}
\arguments{
\item{seurat_obj}{Seurat object containing the single-cell data.}

\item{sex_column}{Character. Column name in metadata for sex (default "sex").}

\item{phenotype_column}{Character. Column name in metadata for phenotype (default "status").}

\item{celltype_column}{Character. Column name in metadata for cell type (default "cell_type").}

\item{sex_labels_vector}{Character vector of sex labels (default c("F","M")).}

\item{min_logfc}{Numeric. Minimum absolute log fold change threshold (default 0.25).}

\item{phenotype_labels_vector}{Character vector of phenotype groups (default c("WT","TG")).}

\item{method}{Character. Statistical test to use for differential expression (default "wilcox").}
}
\value{
A list with male and female DEGs results.
}
\description{
Identifies differentially expressed genes (DEGs) separately for male and female samples
within different cell types using the Seurat package. Compares gene expression between control
and perturbed groups in each sex.
}
