% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.WCE.R
\name{plot.WCE}
\alias{plot.WCE}
\title{Plot of the weight function(s) estimated by \code{WCE}}
\usage{
\method{plot}{WCE}(x, allres = FALSE, ...)
}
\arguments{
\item{x}{A \code{WCE} object.}

\item{allres}{Logical. If TRUE, then all the weight functions from the WCE object are plotted simultaneously. If FALSE, then only the best function, determined by AIC or BIC, is plotted. Default to FALSE.}

\item{\dots}{Optional. Additional arguments to be passed to \code{plot} (none currently used).}
}
\description{
Method to plot the weight function(s) of a \code{WCE} object. Can plot the best estimated weight function or all the estimated functions simultaneously.
}
\examples{
wce <- WCE(drugdata, "Cox", 1, 90, constrained = "R", id = "Id", event = "Event",
start = "Start", stop = "Stop", expos = "dose", covariates = c("age", "sex"))
plot(wce)

}
\references{
Sylvestre, M. P., & Abrahamowicz, M. (2009). Flexible modeling of the cumulative effects of time-dependent exposures on the hazard. Statistics in medicine, 28(27), 3437-3453.
}
