% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_Exhibit.R
\name{w_Exhibit}
\alias{w_Exhibit}
\title{Extract the first paragraph of a Wikipedia article with a maximum of characters.}
\usage{
w_Exhibit(
  entities,
  mode = "default",
  langsorder = "en",
  wikilangs = langsorder,
  links = c("wikidata", "wiki", "BNE", "RAH", "ISNI"),
  info = FALSE,
  imgpath = NULL,
  nlimit = MW_LIMIT,
  debug = FALSE,
  ...
)
}
\arguments{
\item{entities}{A vector or data.frame of entities, whose entries have to be extracted.}

\item{mode}{type of data to be extracted, default=people.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. For label and description, English is used for
language failback, if they are not in English, then information is returned
in any else language. The language for label and description are also
returned. If langsorder=='', then no other information than labels or
descriptions are returned in any language, only Wikidata entities, else,
use the order in this parameter to retrieve information.}

\item{wikilangs}{List of languages to limit the search of Wikipedia pages,
using "|" as separator. Wikipedias pages are returned in same order as
languages in this parameter. If wikilangs='' the function returns Wikipedia
pages in any language, not sorted.}

\item{links}{Vector of IDs for linking to its catalog. V.gr. c("Wikidata", "Wikipedia", "BNE", "RAH)}

\item{info}{Add the first paragraph of Wikipedia in the template.}

\item{imgpath}{Name of the directory where there are image files.}

\item{nlimit}{If the number of entities exceeds this number, chunked queries
are done. This is the number of entities requested in each chunk. Please,
reduce the default value if error is raised.}

\item{debug}{For debugging (info or query).}

\item{...}{Same arguments as in netCoin::exhibit().}
}
\value{
An object of gallery_rd3 class.
}
\description{
Extract the first paragraph of a Wikipedia article with a maximum of characters.
}
\examples{
\dontrun{
## Obtaining information in English Wikidata
names <- c("William Shakespeare", "Pedro Almodovar")
info <- getWikiInf(names)
w_Exhibit(info$Q)
}
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
