% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{tshistogram}
\alias{tshistogram}
\title{Histograms}
\usage{
tshistogram(
  x,
  bins = NULL,
  density = FALSE,
  density.lwidth = 0.7,
  title = NULL,
  x.name = NULL,
  x.col = "darkgrey",
  density.col = "steelblue4"
)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{bins}{a numeric value to specify the number of bins in the histogram. Can be omitted. Default is \code{NULL}.}

\item{density}{logical. Indicate whether the density curve of the normal distribution should be included. Default is \code{FALSE}.}

\item{density.lwidth}{line width of the density curve in the output plot. Will be ignored if \code{density = FALSE}. Default is 0.7.}

\item{title}{title of the histogram. Default is \code{NULL}.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{x.col}{colour of the histogram bars. Default is `\code{darkgrey}`.}

\item{density.col}{colour of the density curve. Will be ignored if \code{density = FALSE}. Default is `\code{steelblue4}`.}
}
\value{
A histogram of \code{x} will be displayed with no further values or objects returned.
}
\description{
Produce a histogram of a given univariate time series.
}
\examples{
tshistogram(airport$Travellers, density = TRUE)
}
\references{
Venables, W. N., & Ripley. B. D. (2002) Modern Applied Statistics with S. Springer.
}
\author{
Ka Yui Karl Wu
}
