% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bal_unbal_tree.R
\name{create_fully_unbalanced_tree}
\alias{create_fully_unbalanced_tree}
\title{Create an unbalanced tree (caterpillar tree)}
\usage{
create_fully_unbalanced_tree(phy)
}
\arguments{
\item{phy}{phylo object}
}
\value{
phylo phylo object
}
\description{
This function takes an input phylogeny, and returns a phylogeny
that is a perfectly imbalanced tree (e.g. a full caterpillar tree), that
has the same branching times as the original input tree.
}
\examples{
phy <- ape::rphylo(n = 16, birth = 1, death = 0)
bal_tree <- treestats::create_fully_unbalanced_tree(phy)
treestats::colless(phy)
treestats::colless(bal_tree) # much higher
}
