% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_sequences}
\alias{plot_sequences}
\alias{plot_sequences.tna}
\alias{plot_sequences.tna_data}
\alias{plot_sequences.default}
\alias{plot_sequences.group_tna}
\title{Create a Sequence Index Plot or a Distribution Plot}
\usage{
plot_sequences(x, ...)

\method{plot_sequences}{tna}(
  x,
  group,
  type = "index",
  scale = "proportion",
  geom = "bar",
  include_na = FALSE,
  na_color = "white",
  sort_by,
  show_n = TRUE,
  border,
  title,
  legend_title,
  xlab,
  ylab,
  tick = 5,
  ncol = 2L,
  ...
)

\method{plot_sequences}{tna_data}(
  x,
  group,
  type = "index",
  scale = "proportion",
  geom = "bar",
  include_na = FALSE,
  colors,
  na_color = "white",
  sort_by,
  show_n = TRUE,
  border,
  title,
  legend_title,
  xlab,
  ylab,
  tick = 5,
  ncol = 2L,
  ...
)

\method{plot_sequences}{default}(
  x,
  cols,
  group,
  type = "index",
  scale = "proportion",
  geom = "bar",
  include_na = FALSE,
  colors,
  na_color = "white",
  sort_by,
  show_n = TRUE,
  border,
  title,
  legend_title,
  xlab,
  ylab,
  tick = 5,
  ncol = 2L,
  ...
)

\method{plot_sequences}{group_tna}(
  x,
  type = "index",
  scale = "proportion",
  geom = "bar",
  include_na = FALSE,
  na_color = "white",
  sort_by,
  show_n = TRUE,
  border,
  title,
  legend_title,
  xlab,
  ylab,
  tick = 1,
  ncol = 2L,
  ...
)
}
\arguments{
\item{x}{A \code{tna}, \code{group_tna}, \code{tna_data} or a \code{data.frame} object with
sequence data in wide format.}

\item{...}{Ignored.}

\item{group}{A vector indicating the group assignment of each
row of the data. Must have the same length as the
number of rows of \code{x}. Alternatively, a single \code{character} string giving
the column name of the data that defines the group when \code{x} is a wide
format \code{data.frame} or a \code{tna_data} object. Used for faceting the plot.}

\item{type}{A \code{character} string for the type of plot to generate. The
available options are  \code{"index"} (the default) for a sequence index plot,
and \code{"distribution"} showing the distribution of the states over time.}

\item{scale}{A \code{character} string that determines the scaling of the
vertical axis for distribution plots. The options are \code{"proportion"}
(the default) and \code{"count"} for proportions and raw counts of states,
respectively.}

\item{geom}{A \code{character} string for the type of geom to use for
distribution plots. The options are \code{"bar"} (the default) and \code{"area"}.}

\item{include_na}{A \code{logical} value for whether to include missing values
for distribution plots. The default is \code{FALSE}. If \code{TRUE}, the missing
values are converted to a new state and included in the plot.}

\item{na_color}{A \code{character} string giving the color to use for missing
values. The default is \code{"white"}.}

\item{sort_by}{Either a \code{character} vector of column names of \code{x} to sort
by or \code{"everything"} to sort by every column.
If missing, no sorting is done.}

\item{show_n}{A \code{logical} value for whether to add the number of
observations (total or by group) to the plot title.}

\item{border}{A \code{character} string giving the color for borders. For index
plots, this is the color of borders between cells (tiles). For
distribution plot with \code{geom = "bar"}, this is the color of bar outlines.
Not applicable to \code{geom = "area"}.}

\item{title}{An optional \code{character} string providing a title for the plot.}

\item{legend_title}{An optional \code{character} string providing a title for the
legend.}

\item{xlab}{A \code{character} string giving the label for the horizontal axis.
The default is \code{"Time"}.}

\item{ylab}{A \code{character} string giving the label for the vertical axis.
The default is \code{"Sequence"} for index plots, and \code{"Proportion"} or
\code{"Count"} based on \code{scale} for distribution plots.}

\item{tick}{An \code{integer} specifying the horizontal axis label interval. The
default value \code{tick = 5} shows every 5th label. Setting this to 1 will show
every label.}

\item{ncol}{Number of columns to use for the facets. The default is 2.}

\item{colors}{A named \code{character} vector mapping states to colors, or an
unnamed \code{character} vector. If missing, a default palette is used.}

\item{cols}{A \code{character} Vector of column names to be treated as
time points. If missing, all columns will be used.}
}
\description{
Create a Sequence Index Plot or a Distribution Plot
}
\examples{
# Sequence index plot (default)
plot_sequences(
  group_regulation,
  group = rep(1:2, each = 1000),
)
# State distribution plot
plot_sequences(
  group_regulation,
  group = rep(1:2, each = 1000),
  type = "distribution",
)

}
