% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_evaluation.R
\name{print_evaluation}
\alias{print_evaluation}
\title{Prints cross-validation results}
\usage{
print_evaluation(model)
}
\arguments{
\item{model}{A model resulting from \code{\link[=rf_evaluate]{rf_evaluate()}}.}
}
\value{
A table printed to the standard output.
}
\description{
Prints the results of an spatial cross-validation performed with \code{\link[=rf_evaluate]{rf_evaluate()}}.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)
data(distance_matrix)

#fitting random forest model
rf.model <- rf(
  data = plant_richness_df,
  dependent.variable.name = "richness_species_vascular",
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  distance.matrix = distance_matrix,
  distance.thresholds = 0,
  n.cores = 1,
  verbose = FALSE
)

#evaluation with spatial cross-validation
rf.model <- rf_evaluate(
  model = rf.model,
  xy = plant_richness_df[, c("x", "y")],
  n.cores = 1
)

#checking evaluation results
print_evaluation(rf.model)

}
}
\seealso{
\code{\link[=plot_evaluation]{plot_evaluation()}}, \code{\link[=get_evaluation]{get_evaluation()}}
}
