% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmbasis.matrix.R
\name{kmbasis.matrix}
\alias{kmbasis.matrix}
\title{Compute the basis of a knowledge space}
\usage{
\method{kmbasis}{matrix}(x, ...)
}
\arguments{
\item{x}{Binary matrix representing a knowledge space}

\item{...}{Space or future, optional parameters}
}
\value{
Binary matrix representing the basis of the knowledge space.
}
\description{
\code{kmbasis.matrix} returns a matrix representing the basis of a
knowledge space. If \code{x} is a knowledge structure or an
arbitrary family of sets \code{kmreduction} returns the basis of
the smallest knowledge space containing \code{x}.
}
\examples{
kmbasis(xpl$space)

}
\seealso{
Other Different representations for knowledge spaces: 
\code{\link{kmSR2basis}()},
\code{\link{kmbasis.kmsurmisefunction}()},
\code{\link{kmbasis.kmsurmiserelation}()},
\code{\link{kmsf2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmsurmiserelation}()},
\code{\link{kmunionclosure}()}
}
\concept{Different representations for knowledge spaces}
