% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observed_vs_theoretical.R
\name{observed_vs_theoretical}
\alias{observed_vs_theoretical}
\title{Plot observed vs predicted distribution of a fitted model}
\usage{
observed_vs_theoretical(model)
}
\arguments{
\item{model}{A statistical model.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plot observed vs predicted distribution of a fitted model
}
\details{
Has been tested with \code{\link[stats:lm]{stats::lm()}} and \code{\link[stats:glm]{stats::glm()}} models. It may work
with other types of models, but without any warranty.
}
\examples{
# a linear model
mod <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris)
mod |> observed_vs_theoretical()

# a logistic regression
mod <- glm(
  as.factor(Survived) ~ Class + Sex,
  data = titanic,
  family = binomial()
)
mod |> observed_vs_theoretical()
}
\keyword{models}
