% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_sobol_jansen}
\alias{plot_sobol_jansen}
\title{Plotting Sobol-Jansen Values Barplot}
\usage{
plot_sobol_jansen(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "Sobol_Jansen")'.}

\item{show_table}{Boolean. Whether to print Sobol-Jansen results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_sobol_jansen()} function displays first-order and total-order
Sobol indices decomposing total output variance into contributions from
individual features and higher-order interaction terms. Implements
variance-based global sensitivity analysis providing comprehensive
understanding of feature contributions to output uncertainty, with
application restricted to continuous predictor variables.
}
\examples{
# Note: For obtaining the Sobol_Jansen plot the user needs to complete till
# sensitivity_analysis( ) function of the MLwrap pipeline using
# the Sobol_Jansen method.
# See the full pipeline example under sensitivity_analysis()
# (Requires sensitivity_analysis(methods = "Sobol_Jansen"))
# Final call signature:
# plot_sobol_jansen(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
