% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_pfi}
\alias{plot_pfi}
\title{Plotting Permutation Feature Importance Barplot}
\usage{
plot_pfi(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with
'sensitivity_analysis(methods = "PFI")'.}

\item{show_table}{Boolean. Whether to print PFI results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_pfi()} function generates feature importance estimates via
Permutation Feature Importance measuring performance degradation when each
feature's values are randomly permuted while holding all other features
constant. Provides model-agnostic importance ranking independent of
feature-target correlation patterns, capturing both linear and non-linear
predictive contributions to model performance.
}
\examples{
# Note: For obtaining the PFI plot results the user needs to complete till
# sensitivity_analysis( ) function of the MLwrap pipeline using the PFI
# method.
# See the full pipeline example under sensitivity_analysis()
# (Requires sensitivity_analysis(methods = "PFI"))
# Final call signature:
# plot_pfi(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
