% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-SemNeTShiny.R
\name{plot.animateShiny}
\alias{plot.animateShiny}
\title{Animate Networks for Spreading Activation from Shiny}
\usage{
\method{plot}{animateShiny}(x, ...)
}
\arguments{
\item{x}{Shiny result \code{resultShiny$spreadingActivationPlot}}

\item{...}{Additional arguments for \code{\link[animation]{ani.record}}}
}
\value{
Plots animated networks using \code{\link[qgraph]{qgraph}} and \code{\link[animation]{ani.record}}
}
\description{
Uses \code{\link[qgraph]{qgraph}} and \code{\link[animation]{ani.record}}
to animate networks. Accepts only one network animation at a time
}
\examples{

if(interactive())
{SemNeTShiny()}

\dontrun{
  plot(resultShiny$spreadingActivationPlot[[1]])
}

}
\references{
Epskamp, S., Cramer, A. O. J., Waldorp, L. J., Schmittmann, V. D., & Borsboom, D. (2012).
qgraph: Network visualizations of relationships in psychometric data.
\emph{Journal of Statistical Software}, \emph{48}, 1-18.
Retrieved from: http://www.jstatsoft.org/v48/i04/

Siew, C. S. Q. (2019).
spreadr: An R package to simulate spreading activation in a network.
\emph{Behavior Research Methods}, \emph{51}, 910-929.
https://doi.org/10.3758/s13428-018-1186-5
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
