% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{autoboost_gamlss}
\alias{autoboost_gamlss}
\title{AutoBoost for GAMLSS (SelectBoost-style)}
\usage{
autoboost_gamlss(
  formula,
  data,
  family,
  mu_scope,
  sigma_scope = NULL,
  nu_scope = NULL,
  tau_scope = NULL,
  base_sigma = ~1,
  base_nu = ~1,
  base_tau = ~1,
  c0_grid = seq(0.1, 0.9, by = 0.1),
  B = 60,
  sample_fraction = 0.7,
  pi_thr = 0.6,
  k = 2,
  direction = c("both", "forward", "backward"),
  pre_standardize = FALSE,
  trace = TRUE,
  progress = TRUE,
  use_groups = TRUE,
  corr_func = "cor",
  group_fun = SelectBoost::group_func_2,
  ...
)
}
\arguments{
\item{formula}{Base formula for the location \eqn{\mu} parameter (in the main model call).}

\item{data}{Data frame.}

\item{family}{A \code{gamlss.dist} family object (e.g., \code{gamlss.dist::NO()}).}

\item{mu_scope}{Formula of candidate terms for \eqn{\mu}.}

\item{sigma_scope, nu_scope, tau_scope}{Formulas of candidate terms for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{base_sigma, base_nu, base_tau}{Optional base (always-included) formulas for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{c0_grid}{Numeric vector of \code{c0} values.}

\item{B}{Number of bootstrap subsamples for stability selection.}

\item{sample_fraction}{Fraction of rows per subsample (e.g., 0.7).}

\item{pi_thr}{Selection proportion threshold to define “stable” terms (e.g., 0.6).}

\item{k}{Penalty weight for stepwise GAIC when \code{engine = "stepGAIC"} (default 2).}

\item{direction}{Stepwise direction for \code{stepGAIC} (\code{"both"}, \code{"forward"}, \code{"backward"}).}

\item{pre_standardize}{Logical; standardize numeric predictors before penalized fits.}

\item{trace}{Logical; print progress messages.}

\item{progress}{Logical; show a progress bar in sequential runs.}

\item{use_groups}{Logical; treat SelectBoost correlation groups during resampling.}

\item{corr_func}{Correlation function passed to \code{SelectBoost::boost.compcorrs}.}

\item{group_fun}{Grouping function passed to \code{SelectBoost::boost.findgroups}.}

\item{...}{Passed to underlying engines (e.g., to \code{gamlss::gamlss}, \code{glmnet}, etc.).}
}
\value{
A \code{SelectBoost_gamlss_grid} with summary plots/tables.
}
\description{
Runs a c0 grid, picks the c0 that maximizes total confidence, and returns the corresponding sb_gamlss fit.
}
