% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test3.R
\name{Test3}
\alias{Test3}
\title{Specified Approximation Method}
\usage{
Test3(
  df,
  model,
  var_one,
  var_two,
  PAR,
  threshold,
  fit,
  estimates,
  conc,
  int,
  par_value,
  max_final,
  N,
  signFactor,
  equalCons = 0L,
  calcMeth = "Hessian",
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{var_one}{The first variable of interest.}

\item{var_two}{The second variable of interest.}

\item{PAR}{The path of interest.}

\item{threshold}{The threshold for percentage of data dropped.}

\item{fit}{The SEM object.}

\item{estimates}{The estimates from the SEM model.}

\item{conc}{A data frame containing the parameter of interest.}

\item{int}{The value of the path of interest.}

\item{par_value}{The original value of the parameter of interest.}

\item{max_final}{The maximum number of influential data points to consider.}

\item{N}{The total number of data points.}

\item{signFactor}{A factor indicating the direction of parameter change (positive or negative).}

\item{equalCons}{The equality constraint used in the SEM model (default is 0).}

\item{calcMeth}{The method used for approximation (default is 'Hessian').}

\item{...}{Other arguments.}
}
\value{
A list of class \code{TestResult3} containing:
\item{methodname}{The name of the method used.}
\item{testindex}{The index of the test performed.}
\item{max_drops}{The maximum number of data points dropped.}
\item{est_diff}{The expected change in parameter value.}
\item{act_diff}{The actual change in parameter value.}
\item{final_par_value}{The parameter value after dropping the influential points.}
\item{initial_par_value}{The original parameter value.}
\item{sign_switch_possible}{Logical indicating whether it was possible to change the sign of the parameter.}
\item{dropped_points}{The indices of the most influential data points.}
}
\description{
This function determines when a specific path in a Structural Equation Modeling (SEM) model changes sign by iteratively removing most influential data points (determined by naive method) and outputs relevant results. Use method 3 - Specified Approximation Method.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)
library(R.utils)


# Import data
df <- PoliticalDemocracy

# Build Model
model <- '
  # measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  # regressions
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  # residual correlations
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

var_one <- 'dem65' # first term
var_two <- 'ind60' # second term
PAR <- c("dem65~ind60") # full relation
threshold <- 10

# Fit SEM model
fit <- lavaan::sem(model, data = df)
summary(fit)

# Get Estimates of Parameters from SEM
estimates <- parameterEstimates(fit)

# Determine The Value of The Parameter of Interest
conc <- data.frame(lhs = estimates$lhs, rhs = estimates$rhs, est = estimates$est)
int <- conc \%>\% filter(lhs == var_one & rhs == var_two)
par_value <- int$est # this is the value of the parameter of interest

# Compute max number of points to be dropped
max_final <- ceiling(threshold * nrow(df) / 100) # perform rounding if necessary
N <- nrow(df) # store number of observations in df for convenience

# Determine whether parameter is negative or positive in order
# to assess which direction to perturb it
signFactor <- ifelse(par_value >= 0L, TRUE, FALSE)

Test3_result = Test3(df, model, var_one, var_two, PAR, threshold, fit, estimates,
conc, int, par_value, max_final, N, signFactor,equalCons = 0L)
summary(Test3_result)
}
}
