% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInput.R
\name{checkInput}
\alias{checkInput}
\title{Check if the root scan directories contain everything necessary}
\usage{
checkInput(data_dir = NULL, data_dirs = NULL)
}
\arguments{
\item{data_dir}{(Optional, default = NULL) String specifying the name
(full path) of the directory  (full path) containing all root scan
directories of interest.}

\item{data_dirs}{(Optional, default = NULL) Character vector specifying all
of the individual root scan directories of interest (full paths). This is
only used if \code{data_dir} is set to NULL.}
}
\value{
\code{checkInput} A list containing two TRUE-FALSE-vectors showing
if the root scan directories each contain the two root pictures.
}
\description{
\code{checkInput} - This function checks a set of root scan
directories if they each contain two pictures, X.segmentation.png and
X.skeleton.png, where X is the name of the directory.
}
\examples{
# Replace NULL with path to directory.
DATA_DIR <- NULL
# Apply the function directly...
cI1 <- checkInput(data_dir = DATA_DIR)
# ... or use it in combination with \code{getOverviewInput}:
cI2 <- checkInput(data_dirs = getOverviewInput(data_dir = DATA_DIR,
                                     naming_conv = "standard")$dir_name_full)
}
