% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-TableCollection.R
\name{TableCollection}
\alias{TableCollection}
\title{Table collection R6 class (TableCollection)}
\description{
An R6 class holding an external pointer to a table collection
object. As an R6 class, its methods look Pythonic and therefore resemble the
tskit Python API. Since the class only holds the pointer, it is lightweight.
Currently there is a limited set of R methods for working the tree sequence.
}
\examples{

## ------------------------------------------------
## Method `TableCollection$new`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
is(tc)
tc

## ------------------------------------------------
## Method `TableCollection$dump`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
dump_file <- tempfile()
tc$dump(dump_file)
tc$write(dump_file) # alias
\dontshow{file.remove(dump_file)}

## ------------------------------------------------
## Method `TableCollection$tree_sequence`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
ts <- tc$tree_sequence()
is(ts)

## ------------------------------------------------
## Method `TableCollection$r_to_py`
## ------------------------------------------------

\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")
  tc_r <- tc_load(ts_file)
  is(tc_r)
  tc_r$print()

  # Transfer the table collection to reticulate Python and use tskit Python API
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    tc_py <- tc_r$r_to_py()
    is(tc_py)
    tmp <- tc_py$simplify(samples = c(0L, 1L, 2L, 3L))
    tmp
    tc_py$individuals$num_rows # 2
    tc_py$nodes$num_rows # 8
    tc_py$nodes$time # 0.0 ... 5.0093910
  }
}

## ------------------------------------------------
## Method `TableCollection$print`
## ------------------------------------------------

ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- tc_load(file = ts_file)
tc$print()
tc
}
\seealso{
\code{\link{tc_py_to_r}}, \code{\link{tc_load}}, and
  \code{\link[=TableCollection]{TableCollection$dump}}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pointer}}{external pointer to the table collection}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TableCollection-new}{\code{TableCollection$new()}}
\item \href{#method-TableCollection-dump}{\code{TableCollection$dump()}}
\item \href{#method-TableCollection-write}{\code{TableCollection$write()}}
\item \href{#method-TableCollection-tree_sequence}{\code{TableCollection$tree_sequence()}}
\item \href{#method-TableCollection-r_to_py}{\code{TableCollection$r_to_py()}}
\item \href{#method-TableCollection-print}{\code{TableCollection$print()}}
\item \href{#method-TableCollection-clone}{\code{TableCollection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{\link{TableCollection}} from a file or a pointer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$new(
  file,
  skip_tables = FALSE,
  skip_reference_sequence = FALSE,
  pointer = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{a string specifying the full path of the tree sequence file.}

\item{\code{skip_tables}}{logical; if \code{TRUE}, load only non-table information.}

\item{\code{skip_reference_sequence}}{logical; if \code{TRUE}, skip loading
reference sequence information.}

\item{\code{pointer}}{an external pointer (\code{externalptr}) to a table collection.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the corresponding Python function at
  \url{https://github.com/tskit-dev/tskit/blob/dc394d72d121c99c6dcad88f7a4873880924dd72/python/tskit/tables.py#L3463}.
}

\subsection{Returns}{
A \code{\link{TableCollection}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
is(tc)
tc
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-dump"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-dump}{}}}
\subsection{Method \code{dump()}}{
Write a table collection to a file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$dump(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{a string specifying the full path of the tree sequence file.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.TableCollection.dump}.
}

\subsection{Returns}{
No return value; called for side effects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
dump_file <- tempfile()
tc$dump(dump_file)
tc$write(dump_file) # alias
\dontshow{file.remove(dump_file)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-write"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-write}{}}}
\subsection{Method \code{write()}}{
Alias for \code{\link[=TableCollection]{TableCollection$dump}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$write(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{see \code{\link[=TableCollection]{TableCollection$dump}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-tree_sequence"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-tree_sequence}{}}}
\subsection{Method \code{tree_sequence()}}{
Create a \code{\link{TreeSequence}} from this table collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$tree_sequence()}\if{html}{\out{</div>}}
}

\subsection{Details}{
See the corresponding Python function at
  \url{https://tskit.dev/tskit/docs/latest/python-api.html#tskit.TableCollection.tree_sequence}.
}

\subsection{Returns}{
A \code{\link{TreeSequence}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- TableCollection$new(file = ts_file)
ts <- tc$tree_sequence()
is(ts)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-r_to_py"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-r_to_py}{}}}
\subsection{Method \code{r_to_py()}}{
This function saves a table collection from R to disk and
  loads it into reticulate Python for use with the \code{tskit} Python API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$r_to_py(tskit_module = get_tskit_py(), cleanup = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tskit_module}}{reticulate Python module of \code{tskit}. By default,
it calls \code{\link{get_tskit_py}} to obtain the module.}

\item{\code{cleanup}}{logical; delete the temporary file at the end of the function?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See \url{https://tskit.dev/tutorials/tables_and_editing.html#tables-and-editing}
  on what you can do with the tables.
}

\subsection{Returns}{
Table collection in reticulate Python.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")
  tc_r <- tc_load(ts_file)
  is(tc_r)
  tc_r$print()

  # Transfer the table collection to reticulate Python and use tskit Python API
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    tc_py <- tc_r$r_to_py()
    is(tc_py)
    tmp <- tc_py$simplify(samples = c(0L, 1L, 2L, 3L))
    tmp
    tc_py$individuals$num_rows # 2
    tc_py$nodes$num_rows # 8
    tc_py$nodes$time # 0.0 ... 5.0093910
  }
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-print"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of a table collection and its contents.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with two data.frames; the first contains table collection
  properties and their values; the second contains the number of rows in
  each table and the length of their metadata.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ts_file <- system.file("examples/test.trees", package = "RcppTskit")
tc <- tc_load(file = ts_file)
tc$print()
tc
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TableCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
