% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WASI.R
\name{WASI}
\alias{WASI}
\title{Weighted Average Stress Index (WASI)}
\usage{
WASI(data, decimals = 5)
}
\arguments{
\item{data}{A data frame containing genotype IDs (\code{Gen}) and stress index values
(\code{GMP}, \code{HM}, \code{MP}, \code{MRP}, \code{PYR}, \code{RSI}, \code{SSPI}, \code{STI}, \code{TOL}, \code{YI}, \code{YSI}).}

\item{decimals}{Integer; number of decimal places to use for Excel-style data.
All indices are rounded to this precision before ranking and again for the
index × rank products (default \code{5}).}
}
\value{
A data frame with \code{Gen} and its computed \code{WASI} (sorted in descending order).
}
\description{
A composite measure that computes the weighted mean for each genotype across
multiple stress indices, accounting for whether higher or lower values are better.
}
\details{
The Weighted Average Stress Index for genotype \emph{i} is
\deqn{WASI_i = \frac{\sum_{j=1}^{k} (X_{ij} \times R_{ij})}{\sum_{j=1}^{k} R_{ij}},}
where \eqn{X_{ij}} is the value of genotype \emph{i} for index \emph{j}, and \eqn{R_{ij}}
is its rank, determined by whether higher or lower values are favorable.
Ranks use Excel-like behavior (\code{ties.method = "min"}). Indices are rounded to
\code{decimals} places prior to ranking and multiplication to better match Excel-style
calculations.
}
\examples{
df <- data.frame(
Gen = paste0("G", 1:5),
GMP  = c(1:5),
HM   = c(6:10),
MP   = c(11:15),
MRP  = c(16:20),
PYR  = c(21:25),
RSI  = c(26:30),
SSPI = c(31:35),
STI  = c(0.1, 0.2, 0.3, 0.4, 0.5),
TOL  = c(41:45),
YI   = c(0.6, 0.7, 0.8, 0.9, 1.0),
YSI  = c(0.2, 0.3, 0.4, 0.5, 0.6)
)
WASI(df)

}
