% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMisc.R
\name{plotPathDistances}
\alias{plotPathDistances}
\title{Accessory function to plot pathway space distances}
\usage{
plotPathDistances(pdist, z.transform = FALSE)
}
\arguments{
\item{pdist}{A list generated by the \code{\link{pathDistances}} function.}

\item{z.transform}{A single logical value specifying to convert pathway 
distances into z-score values.}
}
\value{
A 'ggplot' object.
}
\description{
Accessory function to plot pathway space distances
}
\examples{

# Load a vertex-wise distance matrix (distance between nodes in a graph)
data("gdist.toy", package = "PathwaySpace")

# Get two gene lists
from <- sample(colnames(gdist.toy), 50)
to <- sample(colnames(gdist.toy), 50)

# Calculate distances between lists, and between random lists
res <- pathDistances(gdist.toy, from, to)

# Plot observed and null distances
plotPathDistances(res)

}
