% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortQueries.R
\name{processCohorts}
\alias{processCohorts}
\title{Extract the cohort parents and children cohorts (cohorts derieved from the parent cohort)}
\usage{
processCohorts(cohort)
}
\arguments{
\item{cohort}{The data.frame extracted using `getCohortDefinitions()`}
}
\value{
Returns a list containing parents: a named vector of all the parent cohorts and cohortList: a list 
the same length as the parent vector with the first element containing all the children
of the first parent cohort, the second element containing the children of the second parent, etc.
}
\description{
This function lets you split the cohort data.frame into the parents and the children per parent.
}
\details{
Finds the parent cohorts and children cohorts
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cohortDef <- getCohortDefinitions(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

parents <- processCohorts(cohortDef)

}
\seealso{
Other Cohorts: 
\code{\link{getCohortCounts}()},
\code{\link{getCohortDefinitions}()},
\code{\link{getCohortInclusionRules}()},
\code{\link{getCohortInclusionStats}()},
\code{\link{getCohortInclusionSummary}()},
\code{\link{getCohortMeta}()},
\code{\link{getCohortSubsetDefinitions}()}
}
\concept{Cohorts}
