% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getTargetBinaryFeatures}
\alias{getTargetBinaryFeatures}
\title{Extract aggregate statistics of binary feature analysis IDs of interest for targets (ignoring excluding people with prior outcome)}
\usage{
getTargetBinaryFeatures(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetId = NULL,
  databaseIds = NULL,
  analysisIds = NULL,
  conceptIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetId}{An integer corresponding to the target cohort ID}

\item{databaseIds}{(optional) A vector of database ids to restrict to}

\item{analysisIds}{(optional) The feature extraction analysis ID of interest (e.g., 201 is condition)}

\item{conceptIds}{(optional) The feature extraction concept ID of interest to restrict to}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{covariateId the id of the feature}
 \item{covariateName the name of the feature}
 \item{sumValue the number of target patients who have the feature value of 1 (target patients are restricted to first occurrence and require min prior obervation days)}
 \item{averageAvalue the fraction of target patients who have the feature value of 1 (target patients are restricted to first occurrence and require min prior obervation days)}
}
}
\description{
This function extracts the feature extraction results for targets corresponding to specified target
 but does not exclude any patients with the outcome during the outcome washout (so it agnostic to the outcome of interest).
}
\details{
Specify the connectionHandler, the schema and the target cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

tbf <- getTargetBinaryFeatures (
connectionHandler = connectionHandler, 
schema = 'main',
targetId = 1
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
