% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionAggregateTopPredictors}
\alias{getPredictionAggregateTopPredictors}
\title{Extract the top N predictors across a set of models}
\usage{
getPredictionAggregateTopPredictors(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  modelDesignIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{modelDesignIds}{One or more model design IDs to restrict to}
}
\value{
Returns a data.frame with the columns: 
\itemize{
 \item{databaseName the name of the database the model was developed on}
 \item{tarStartDay the time-at-risk start day}
 \item{tarStartAnchor whether the time-at-risk start is relative to cohort start or end}
 \item{tarEndDay the time-at-risk end day}
 \item{tarEndAnchor whether the time-at-risk end is relative to cohort start or end}
 \item{covariateId the FeatureExtraction covariate identifier}
 \item{covariateName the name of the covariate}
 \item{conceptId the covariates corresponding concept or 0}
 \item{sumCovariateValue the total absolute feature importance or coefficient value}
 \item{numberOfTimesPredictive number of models that contained the covariate}
}
}
\description{
This function extracts the top N predictors across models by 
finding the sum of the absolute coefficient value across models.
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) any modelDesignIds to restrict to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

topPreds <- getPredictionAggregateTopPredictors(
  connectionHandler = connectionHandler, 
  schema = 'main',
  modelDesignIds = c(1,2,5)
)

}
\seealso{
Other Prediction: 
\code{\link{getFullPredictionPerformances}()},
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionCovariates}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionLift}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionOutcomes}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()},
\code{\link{getPredictionTargets}()},
\code{\link{getPredictionTopPredictors}()}
}
\concept{Prediction}
