% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getDechallengeRechallengeFails}
\alias{getDechallengeRechallengeFails}
\title{A function to extract the failed dechallenge-rechallenge cases}
\usage{
getDechallengeRechallengeFails(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  targetId = NULL,
  outcomeId = NULL,
  databaseId = NULL,
  dechallengeStopInterval = NULL,
  dechallengeEvaluationWindow = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{targetId}{An integer corresponding to the target cohort ID}

\item{outcomeId}{Am integer corresponding to the outcome cohort ID}

\item{databaseId}{The unique identifier for the database of interest}

\item{dechallengeStopInterval}{(optional) The maximum number of days between the outcome start and target end for an outcome to be flagged}

\item{dechallengeEvaluationWindow}{(optional) The maximum number of days after the target restarts to see whether the outcome restarts}
}
\value{
A data.frame each failed dechallenge rechallenge exposures and outcomes
}
\description{
A function to extract the failed dechallenge-rechallenge cases
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs and database id
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

conCohort <- getDechallengeRechallengeFails(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetId = 1, 
  outcomeId = 3,
  databaseId = 'eunomia'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTargetContinuousFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
