% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryReports.R
\name{generateSummaryPredictionReport}
\alias{generateSummaryPredictionReport}
\title{generateSummaryPredictionReport}
\usage{
generateSummaryPredictionReport(
  connectionHandler,
  schema,
  targetIds = NULL,
  outcomeIds = NULL,
  plpTablePrefix = "plp_",
  databaseTablePrefix = "",
  cgTablePrefix = "cg_",
  outputFolder,
  outputFileName = "plp-summary.html",
  intermediatesDir = file.path(tempdir(), "plp-prot"),
  overwrite = FALSE
)
}
\arguments{
\item{connectionHandler}{The connection handler to the results database}

\item{schema}{The result database schema}

\item{targetIds}{The target cohort IDs of interest}

\item{outcomeIds}{The outcome cohort IDs of interest}

\item{plpTablePrefix}{The prediction table prefix}

\item{databaseTablePrefix}{The database table name e.g., database_meta_data}

\item{cgTablePrefix}{The cohort generator table prefix}

\item{outputFolder}{The folder name where file will be save to}

\item{outputFileName}{The file name of the saved report}

\item{intermediatesDir}{The work directory for rmarkdown}

\item{overwrite}{whether to overwrite any existing file at the outputFolder/outputFileName}
}
\value{
A html file is created with the summary report
}
\description{
Generates a summary report for a given targets and outcomes
}
\details{
Specify the connection handler to the result database, the schema name
and the cohortId of interest to generate a html report summarizing the
performance of prediction models in the database.
}
\seealso{
Other Reporting: 
\code{\link{createPredictionReport}()},
\code{\link{generateFullReport}()},
\code{\link{generatePresentation}()},
\code{\link{generatePresentationMultiple}()}
}
\concept{Reporting}
