% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_mixture.R
\name{select_mixture}
\alias{select_mixture}
\title{Mixture Model Selection}
\usage{
select_mixture(
  X,
  G,
  model = c("CN", "GH", "NIG", "SNIG", "SC", "C", "St", "t", "N", "SGH", "HUM", "H",
    "SH"),
  criterion = c("BIC", "AIC", "KIC", "KICc", "AIC3", "CAIC", "AICc", "ICL", "AWE", "CLC"),
  max_iter = 20,
  epsilon = 0.01,
  init_method = c("kmedoids", "kmeans", "hierarchical", "manual"),
  clusters = NULL,
  eta_min = 1.001,
  outlier_cutoff = 0.95,
  deriv_ctrl = list(eps = 1e-08, d = 1e-04, zero.tol = sqrt(.Machine$double.eps/7e-07), r
    = 6, v = 2, show.details = FALSE),
  progress = TRUE
)
}
\arguments{
\item{X}{An \eqn{n} x \eqn{d} matrix or data frame where \eqn{n} is the number of
observations and \eqn{d} is the number of variables.}

\item{G}{The number of clusters, which must be at least 1. If \code{G = 1}, then
both \code{init_method} and \code{clusters} are ignored.}

\item{model}{A vector of character strings indicating the mixture model(s) to be fitted.
See the details section for a list of available distributions. However, all distributions
will be considered by default.}

\item{criterion}{A character string indicating the information criterion for model
selection. "BIC" is used by default. See the details section for a list of available
information criteria.}

\item{max_iter}{(optional) A numeric value giving the maximum number of
iterations each EM algorithm is allowed to use; 20 by default.}

\item{epsilon}{(optional) A number specifying the epsilon value for the
Aitken-based stopping criterion used in the EM algorithm: 0.01 by default.}

\item{init_method}{(optional) A string specifying the method to initialize
the EM algorithm. "kmedoids" clustering is used by default. Alternative
methods include "kmeans", "hierarchical", and "manual". When "manual" is chosen,
a vector \code{clusters} of length \eqn{n} must be specified. If the data set is
incomplete, missing values will be first filled based on the mean imputation method.}

\item{clusters}{(optional) A vector of length \eqn{n} that specifies the initial
cluster memberships of the user when \code{init_method} is set to "manual".
Both numeric and character vectors are acceptable. This argument is NULL by
default, so that it is ignored whenever other given initialization methods
are chosen.}

\item{eta_min}{(optional) A numeric value close to 1 to the right specifying
the minimum value of eta; 1.001 by default. This is only relevant for CN mixture}

\item{outlier_cutoff}{(optional) A number between 0 and 1 indicating the
percentile cutoff used for outlier detection. This is only relevant for t mixture.}

\item{deriv_ctrl}{(optional) A list containing arguments to control the numerical
procedures for calculating the first and second derivatives. Some values are
suggested by default. Refer to functions \code{grad} and \code{hessian} under
the package \code{numDeriv} for more information.}

\item{progress}{(optional) A logical value indicating whether the
fitting progress should be displayed; TRUE by default.}
}
\value{
A list with
  \item{best_mod}{An object of class \code{MixtureMissing} corresponding to the best model.}
  \item{all_mod}{A list of objects of class \code{MixtureMissing} corresponding to all models of consideration.
    The list is in the order of \code{model}.}
  \item{criterion}{A numeric vector containing the chosen information criterion values of all models of consideration.
    The vector is in the order of best-to-worst models.}
Each object of class \code{MixtureMissing} have slots depending on the fitted model. See
the returned value of \link{MCNM} and \link{MGHM}.
}
\description{
Fit mixtures via various distributions and decide the best model based on a given
information criterion. The distributions include multivariate contaminated normal,
multivariate generalized hyperbolic, special and limiting cases of multivariate
generalized hyperbolic.
}
\details{
The function can fit mixtures via the contaminated normal distribution,
generalized hyperbolic distribution, and special and limiting cases of the generalized
hyperbolic distribution. Available distributions include
\itemize{
  \item CN - Contaminated Normal
  \item GH - Generalized Hyperbolic
  \item NIG - Normal-Inverse Gaussian
  \item SNIG - Symmetric Normal-Inverse Gaussian
  \item SC - Skew-Cauchy
  \item C - Cauchy
  \item St - Skew-\emph{t}
  \item t - Student's \emph{t}
  \item N - Normal or Gaussian
  \item SGH - Symmetric Generalized Hyperbolic
  \item HUM- Hyperbolic Univariate Marginals
  \item H - Hyperbolic
  \item SH - Symmetric Hyperbolic
}
Available information criteria include
\itemize{
 \item AIC - Akaike information criterion
  \item BIC - Bayesian information criterion
  \item KIC - Kullback information criterion
  \item KICc - Corrected Kullback information criterion
  \item AIC3 - Modified AIC
  \item CAIC - Bozdogan's consistent AIC
  \item AICc - Small-sample version of AIC
  \item ICL - Integrated Completed Likelihood criterion
  \item AWE - Approximate weight of evidence
  \item CLC - Classification likelihood criterion
}
}
\examples{

data('bankruptcy')

#++++ With no missing values ++++#

X <- bankruptcy[, 2:3]
mod <- select_mixture(X, G = 2, model = c('CN', 'GH', 'St'), criterion = 'BIC', max_iter = 10)

#++++ With missing values ++++#

set.seed(1234)

X <- hide_values(bankruptcy[, 2:3], prop_cases = 0.1)
mod <- select_mixture(X, G = 2, model = c('CN', 'GH', 'St'), criterion = 'BIC', max_iter = 10)

}
\references{
Browne, R. P. and McNicholas, P. D. (2015). A mixture of generalized hyperbolic distributions.
  \emph{Canadian Journal of Statistics}, 43(2):176–198. \cr \cr
Wei, Y., Tang, Y., and McNicholas, P. D. (2019). Mixtures of generalized hyperbolic
  distributions and mixtures of skew-\emph{t} distributions for model-based clustering
   with incomplete data. \emph{Computational Statistics & Data Analysis}, 130:18–41.
}
