\name{print.MaxInt_data_analysis}
\alias{print.MaxInt_data_analysis}
\title{
Print Summary for MaxInt Data Analysis Results
}
\description{
Displays a concise summary of the results from a \code{MaxInt_data_analysis} object, including inference statistics and interaction Explained Sum of Squares (iESS).
}
\usage{
\method{print}{MaxInt_data_analysis}(x, ...)
}
\arguments{
  \item{x}{
An object of class \code{"MaxInt_data_analysis"}, typically returned by the \code{\link{MaxInt_data_analysis}} function.
}
  \item{\dots}{
Additional arguments passed to or from other methods (currently ignored).
}
}
\details{
This method provides a simple print interface for viewing the key components of a \code{MaxInt_data_analysis} object. It prints the results of the permutation-based inference tests 
and the computed \code{Gamma_results}, which contain the interaction Explained Sum of Squares (iESS) for each cluster combinations. 
}
\value{
Returns \code{invisible(x)}. Called primarily for its side effects (printing to the console).
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation-based alternative. \emph{Available on OSF} (submitted to ADAC).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40, 298-331.}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013.}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de) 
}
\note{
This is the default print method for objects of class \code{"MaxInt_data_analysis"}. Use it to quickly inspect inference and iESS results.
}
\seealso{
\code{\link{MaxInt_data_analysis}}
}
\examples{
set.seed(123)
Data <- matrix(rnorm(60), nrow = 10, ncol = 6)
Clus <- matrix(c(2,2, 2,3, 3,2), ncol = 2, byrow = TRUE)
result <- MaxInt_data_analysis(Data, Clus, Nruns = 5, permutations = 10, alpha_level = 0.05)
result
}
\keyword{methods}
\keyword{print}
