\name{Log_Likelihood_function_REMAXINT}
\alias{Log_Likelihood_function_REMAXINT}
\title{
Compute Log-Likelihood for REMAXINT method
}
\description{
Computes the squared error log-likelihood for a given data matrix under the REMAXINT clustering framework.. The function evaluates the fit of the model by comparing the observed data to the reconstructed (fitted) matrix.
}
\usage{
Log_Likelihood_function_REMAXINT(DC, I, J, initM)
}
\arguments{
  \item{DC}{
A numeric data matrix of size \code{I x J}, typically doubly centered, representing the two-mode data to be analyzed.
}
  \item{I}{
An integer specifying the number of rows (first mode entities) in the data matrix (Dc).
}
  \item{J}{
An integer specifying the number of columns (second mode entities) in the data matrix (DC).
}
 \item{initM}{
The matrix M is reconstructed obtained via initial random row partition matrix (R), initial random column partition matrix (C) 
and initial bi-cluster interaction matrix (G) and it is updated after each updation of R, C and G under the REMAXINT model. 
} 
}
\details{
This function is used within the REMAXINT framework to compute the log-likelihood of a model by comparing the original data matrix (\code{DC}) to the estimated matrix (\code{initM}). The error matrix is calculated as the element-wise difference between these two matrices, and the log-likelihood is computed as the sum of squared errors.
}
\value{
A single numeric value representing the log-likelihood (sum of squared residuals).
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl),
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function assumes that both input matrices \code{DC} and \code{initM} are of the same dimensions and numeric type.
}
\seealso{
\code{\link{REMAXINT}}, \code{\link{Update_row_clusters_REMAXINT}}, \code{\link{Update_column_clusters}}, 
\code{\link{matrix}}, \code{\link{sum}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
R  <- diag(1, I, P)
C  <- diag(1, J, Q)
R_inv <- pracma::pinv(t(R) \%*\% R)
C_inv <- pracma::pinv(t(C) \%*\% C)
G <- R_inv \%*\% t(R) \%*\% DC \%*\% C \%*\% C_inv
initM <- R \%*\% G \%*\% t(C)
result <- Log_Likelihood_function_REMAXINT(DC, I, J, initM)
result
}
\keyword{REMAXINT}
\keyword{likelihood}
