% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simuVAR_cpp}
\alias{simuVAR_cpp}
\title{Simulate VAR process}
\usage{
simuVAR_cpp(mdl_h0, burnin = 100L)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item mu: A (\code{q x 1}) vector of means.
  \item sigma: A (\code{q x q}) covariance matrix.
  \item phi:  A (\code{q x qp}) matrix of autoregressive coefficients.
  \item p: Number of autoregressive lags.
  \item q: Number of series.
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated vector autoregressive series and its DGP parameters.
}
\description{
This function simulates a vector autoregresive process.
}
\keyword{internal}
