colreal.mle <- function(x, distr = "normal", v = 5, tol = 1e-07, maxiters = 100, parallel = FALSE) {
  if ( distr == "normal" ) {
    res <- Rfast::colnormal.mle(x)
  } else if ( distr == "laplace" ) {
    res <- Rfast::collaplace.mle(x)
  } else if ( distr == "cauchy" ) {
    res <- Rfast2::colcauchy.mle(x, tol = tol, maxiters = maxiters, parallel = parallel)
  } else if ( distr == "gumbel" ) {
    res <- .colgumbel.mle(x, tol)
  } else if ( distr == "logistic" ) {
    res <- .collogistic.mle(x, tol)
  } else if ( distr == "ct" ) {
    res <- .colct.mle(x, tol)
  } else if ( distr == "t" ) {
    res <- .colt.mle(x, v, tol)
  } else if ( distr == 'wigner' ) {
    res <- .colwigner.mle(x, tol)
  } else if ( distr == 'cauchy0' ) {
    res <- .colcauchy0.mle(x, tol)
  } else if ( distr == 'gnormal0' ) {
    res <- .colgnormal0.mle(x, tol)
  } else if ( distr == "logisbeta" ) {
    res <- .collogisbeta.mle(x, tol = tol, maxiters = maxiters, parallel = parallel)
  }
  res
}



#------colGumbel----------------
.colgumbel.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::gumbel.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'location', 'scale')
  res
}

#-----collogistic--------------------
.collogistic.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::logistic.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'location', 'scale')
  res
}

#----colct-------
.colct.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::ct.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'nu', 'loglik')
  res
}

#-----colt-------
.colt.mle <- function(x, v, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::tmle(x[, i], v, tol) )
  colnames(res) <- c('iters', 'loglik', 'location','scatter')
  res
}

#----colwigner-------
.colwigner.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 2)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::wigner.mle(x[, i], tol) )
  colnames(res) <- c('loglik', 'R')
  res
}

#----colcacuchy0-----
.colcauchy0.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for (i in 1:n)  res[i, ] <- unlist( Rfast2::cauchy0.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik','scale')
  res
}

#---colgnormal0------
.colgnormal0.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for (i in 1:n)  res[i, ] <- unlist( Rfast2::gnormal0.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'alpha','beta')
  res
}

.collogisbeta.mle <- function(x, tol = 1e-7, maxiters = 100, parallel = FALSE) {
  n <- dim(x)[1]
  ex <- exp(-x)
  y <- 1 / ( 1 + ex )
  res <- Rfast2::colbeta.mle(y, tol = tol, maxiters = maxiters, parallel = parallel)
  a <- res[, 1]  ;  b <- res[, 2]
  res[, 3] <-  - n * lbeta(a, b) - b * Rfast::colsums(x) - (a + b) * Rfast::colsums( log1p(ex) )
  res
}

