% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_state.R
\name{gg_states}
\alias{gg_states}
\title{Add states to gg_day() or gg_days() plots}
\usage{
gg_states(
  ggplot_obj,
  State.colname,
  aes_fill = NULL,
  aes_col = NULL,
  ymin = -Inf,
  ymax = Inf,
  Datetime.colname = Datetime,
  alpha = 0.2,
  on.top = FALSE,
  ignore.FALSE = TRUE,
  extract.metric = NULL,
  return.state.data = FALSE,
  ...
)
}
\arguments{
\item{ggplot_obj}{A \code{ggplot} object generated with \code{\link[=gg_day]{gg_day()}} or \code{\link[=gg_days]{gg_days()}}
(or \code{\link[=gg_doubleplot]{gg_doubleplot()}}.}

\item{State.colname, Datetime.colname}{The colnames of the state to add to the
plot, and the column containing the datetimes. Must be part of the dataset.
Expects a \code{symbol}.}

\item{aes_fill, aes_col}{conditional aesthetics for \code{\link[ggplot2:geom_tile]{ggplot2::geom_rect()}}.
The default (\code{NULL}) will be ignored, so that \code{col} and \code{fill} arguments
can be set through the \code{...} arguments. As the states work from a
summarized dataset, only a few columns are available for filling/coloring:
The \code{State.colname}, Grouping variables, and variables created by using
\code{\link[=extract_states]{extract_states()}}.}

\item{ymin, ymax}{customize the height of the state rectangle. By default it
will cover the whole vertical range (-Inf, Inf), but can be set to any
value, including variables generated by \code{\link[=extract_states]{extract_states()}}, which generates
the data for the geom. New variables are accessible through the
\code{extract_metrics} argument.}

\item{alpha}{A numerical value between 0 and 1 representing the transparency
of the states. Default is 0.2.}

\item{on.top}{Logical scalar. If \code{TRUE}, the states will be plotted on top of
the existing plot. If \code{FALSE}, the states will be plotted underneath the
existing plot. Default is \code{FALSE}.}

\item{ignore.FALSE}{Logical that drops \code{FALSE} values of a logical state
column, so that only \code{TRUE} values are recognized as a state. Is only
relevant for logical state columns and will be ignored otherwise. Default
is \code{TRUE}.}

\item{extract.metric}{Expression to be used in \code{\link[=extract_metric]{extract_metric()}}. Can be
used to extract additional information that is then available for
\code{aes_fill}, \code{aes_col}, \code{ymin}, and \code{ymax}. Requires a list containing
variable names and formulas to be converted into calls. E.g., calculating
the median during each state would require \code{list(new_metric = ~median(MEDI))}. Then \code{new_metric} is available for the conditional
arguments.}

\item{return.state.data}{Used for debugging. Returns a tibble with the
extracted state data. If you are uncertain what information is available,
set this to \code{TRUE}.}

\item{...}{Additional arguments given to the \code{\link[ggplot2:geom_tile]{ggplot2::geom_rect()}} used to
construct the state shading. Can be used to change the fill color or other
aesthetic properties.}
}
\value{
a modified \code{ggplot} object with the states added.
}
\description{
\code{\link[=gg_states]{gg_states()}} is a helper function to add state information to plots
generated with \code{\link[=gg_day]{gg_day()}}, \code{\link[=gg_days]{gg_days()}}, or \code{\link[=gg_doubleplot]{gg_doubleplot()}}. The function
can draw on any column in the dataset, but factor-like or logical columns
make the most sense.
}
\examples{
#creating a simple TRUE/FALSE state in the sample data: Light above 250 lx mel EDI
#and a second state that cuts data into chunks relating to the Brown et al. 2022 thresholds
#(+aggregating Data to 5 minute intervals & reducing it to three days)
state_data <-
  sample.data.environment |>
   dplyr::mutate(state = MEDI > 250) |>
   Brown_cut(MEDI, state2) |>
   aggregate_Datetime(unit = "5 mins") |>
   filter_Datetime(length = "3 days")

state_data |>
 gg_days() |>
 gg_states(state)

#state 2 has more than one valid state, thus we need to assign a fill aesthetic
state_data |>
 gg_days() |>
 gg_states(state2, aes_fill = state2) +
 ggplot2::scale_fill_manual(values=c("#868686FF", "#EFC000FF", "#0073C2FF"))
 #this line is simply for sensible colors

#same, but with gg_day()
state_data |>
 dplyr::filter(Id == "Participant") |>
 gg_day(geom = "line") |>
 gg_states(state, fill = "red")

 #more complex state
 state_data |>
 dplyr::filter(Id == "Participant") |>
 gg_day(geom = "line") |>
 gg_states(state2, aes_fill = state2)

 #with gg_doubleplot
 state_data |>
 dplyr::filter(Id == "Participant") |>
 gg_doubleplot() |>
 gg_states(state2, aes_fill = state2)

 #setting the height of the bars 
 state_data |>
 dplyr::filter(Id == "Participant") |>
 gg_day(geom = "line") |>
 gg_states(state2, aes_fill = state2, ymin= -0.5, ymax = 0, alpha = 1) +
 ggplot2::scale_fill_manual(values=c("#868686FF", "#EFC000FF", "#0073C2FF"))

 #setting the height of the bars conditionally based on the median value
 state_data |>
 dplyr::filter(Id == "Participant") |>
 gg_day(geom = "line") |>
 gg_states(state2, aes_fill = state2, ymin= -Inf, ymax = median, alpha = 0.75,
           extract.metric = list(median = ~median(MEDI))) +
 ggplot2::scale_fill_manual(values=c("#868686FF", "#EFC000FF", "#0073C2FF"))
}
