% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{iscamdotplot}
\alias{iscamdotplot}
\title{A dot plot}
\usage{
iscamdotplot(
  response,
  explanatory = NULL,
  main = "",
  xlab = substitute(response),
  ylab = substitute(explanatory)
)
}
\arguments{
\item{response}{Vector of numeric values to plot.}

\item{explanatory}{(optional) second categorical variable to group by.}

\item{main}{(optional) title for the plot.}

\item{xlab}{(optional) x-axis label for the plot.}

\item{ylab}{(optional) y-axis label for the plot. Only displayed when \code{explanatory} is provided.}
}
\value{
A dot plot.
}
\description{
\code{dotplot} creates a horizontal dot plot. If a second categorical variable is
given, the data is grouped by this variable. Use \code{names} & \code{mytitle} to
specify the labels and title.
}
\examples{
iscamdotplot(
  mtcars$cyl,
  main = "mtcars Cylinders Dotplot",
  xlab = "Number of Cylinders"
)
iscamdotplot(
  mtcars$mpg,
  mtcars$am,
  main = "Automatic Cars Have Better Mileage on Average",
  xlab = "Mileage (miles per gallon)",
  ylab = "Automatic (yes coded as 1)"
)
}
