% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_cov_matrix.R
\name{RandCovMtrx}
\alias{RandCovMtrx}
\title{Covariance matrix generator}
\usage{
RandCovMtrx(p = 200, eigenvalues = 0.1 * exp(5 * seq_len(p)/p))
}
\arguments{
\item{p}{dimension of the covariance matrix}

\item{eigenvalues}{the vector of positive eigenvalues}
}
\value{
covariance matrix
}
\description{
Generates a covariance matrix from Wishart distribution with given
eigenvalues or with exponentially decreasing eigenvalues. Useful for examples
and tests when an arbitrary covariance matrix is needed.
}
\details{
This function generates a symmetric positive definite covariance matrix with
given eigenvalues. The eigenvalues can be specified explicitly. Or, by
default, they are generated with exponential decay.
}
\examples{

p<-1e1
# A non-diagonal covariance matrix
Mtrx <- RandCovMtrx(p=p)
Mtrx
}
