% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcscore_calculator.R
\name{pcscore}
\alias{pcscore}
\title{Calculate Principal Component Scores from Count Tables}
\usage{
pcscore(count_table, pc = 1, stabilize_sign = FALSE)
}
\arguments{
\item{count_table}{A data frame of gene count data (genes as rows, samples as columns). All columns must be numeric.}

\item{pc}{Integer vector specifying which principal components to extract (default = 1). Use "all" to return all PCs.}

\item{stabilize_sign}{Logical. Should the sign of each PC be stabilized? (default = FALSE)}
}
\value{
A data frame with PC scores per sample and the sample IDs.
}
\description{
This function computes selected principal component (PC) scores
for each sample in the given count table.
}
\details{
By default, the first principal component (PC1) is returned.
Users can optionally stabilize the sign of each PC.
}
\examples{

count_table <- data.frame(
  sample1 = c(5, 10, 15, 20),
  sample2 = c(6, 11, 16, 21),
  sample3 = c(7, 12, 17, 22)
)
rownames(count_table) <- c("gene1", "gene2", "gene3", "gene4")

pcscore(count_table)

pcscore(count_table, pc = 2)

pcscore(count_table, pc = c(1, 2))

pcscore(count_table, pc = "all")

pcscore(count_table, pc = 1, stabilize_sign = TRUE)

}
