% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fit.R
\name{plot_fit}
\alias{plot_fit}
\title{Plot Observed vs. Fitted Cases}
\usage{
plot_fit(
  models = NULL,
  mod_id = NULL,
  time = NULL,
  group = NULL,
  group_id = NULL,
  mod_label = NULL,
  mod_facet = FALSE,
  palette = "IDE2",
  ref_color = NULL,
  obs_color = NULL,
  obs_label = NULL,
  title = "",
  ci = FALSE,
  transform = "identity",
  xlab = "Time",
  ylab = "Cases",
  xlim = NULL,
  legend = "Model"
)
}
\arguments{
\item{models}{A \code{GHRmodels} object containing fitted model output.}

\item{mod_id}{Character vector of model identifiers (from \code{models$mod_gof$model_id}) to plot.}

\item{time}{Character; name of the time-variable column in \code{models$data}.}

\item{group}{Optional; character name of the column defining independent time series (e.g., spatial areas).}

\item{group_id}{Optional vector of specific group values to subset if \code{group} is provided.}

\item{mod_label}{Optional custom labels for each model. Can be a named vector (e.g., \code{c("mod1" = "Base")})
or an unnamed vector with the same length and order as \code{mod_id}.}

\item{mod_facet}{Logical; if \code{TRUE}, faceting is applied by model. Can be combined with \code{group}.}

\item{palette}{Character; name of the color palette for fitted lines. Default is \code{"IDE2"}.}

\item{ref_color}{Optional color to override the first model's line (reference model).}

\item{obs_color}{Color for observed data line. Default is \code{"black"}.}

\item{obs_label}{Legend label for observed data. Default is \code{"Observed"}.}

\item{title}{Character; title of the plot.}

\item{ci}{Logical; if \code{TRUE}, adds 95\% credible interval ribbons for model fits.}

\item{transform}{Character string for y-axis transformation. Defaults to \code{"identity"} (no transform).
Other options include \code{"log10p1"}, \code{"log1p"}, \code{"sqrt"}, etc.}

\item{xlab}{Label for the x-axis. Default is \code{"Time"}.}

\item{ylab}{Label for the y-axis. Default is \code{"Cases"}.}

\item{xlim}{Character vector of length two in "yyyy-mm-dd" format (e.g., \code{c("2010-01-01", "2020-12-31")}).
Use \code{NA} to leave one side open (e.g., \code{c("2015-01-01", NA)}).}

\item{legend}{Legend title for model lines. Default is \code{"Model"}.}
}
\value{
A \code{ggplot2} object:
\itemize{
\item Time-series line plot of observed vs fitted cases
\item Optionally includes credible intervals and facets by model or group
\item X-axis can be limited by \code{xlim}; Y-axis can be transformed for readability
}
}
\description{
This function creates a time-series plot comparing observed cases with fitted values from one or more models
in a \code{GHRmodels} object. The plot supports faceting by model and/or group.
}
\details{
\itemize{
\item Faceting is flexible: if \code{mod_facet = TRUE} and \code{group} is provided, both are used.
\item If \code{ci = TRUE}, ribbons are plotted for fitted model uncertainty.
\item \code{mod_label}, \code{ref_color}, and \code{obs_color} allow full customization of the legend.
\item The function automatically sums values across replicates for grouped time series.
}
}
\examples{
\donttest{
# Load example GHRmodels object from the package: 
model_list_file <- system.file("examples", "model_list.rds", package = "GHRmodel")
model_list <- readRDS(model_list_file)

# Plot observed vs. fitted cases over time for three selected models
plot_fit(
  models = model_list,                         # A GHRmodels object containing the fitted models
  mod_id = c("mod1", "mod3", "mod5"),          # Vector of model IDs to plot
  mod_label = c("Baseline",                    # Custom display names 
                "tmin.l1.nl",                  
                "pdsi.l1.nl_tmin.l1.nl"),            
  ref_color = "grey",                          # Color for the reference model 
  time = "date",                               # Name of the time variable 
  palette = "Set2",                            # Color palette for fitted lines
  xlim = c("2010-01-01", "2020-01-01"),        # Limit x-axis to this date range
  title = "Fitted vs Observed"                 # Main plot title
)  
}

}
\seealso{
\code{\link{fit_models}} to generate GHRmodels.
}
