% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_inventory.R
\name{forest_inventory_simple}
\alias{forest_inventory_simple}
\title{Function to perform a forest inventory based on a segmented las object (needs to contain TreeID)
This version is a faster but more simplistic approach than forest_inventory() for the DBH estimates}
\usage{
forest_inventory_simple(
  las,
  slice_min = 1.2,
  slice_max = 1.4,
  max_dbh = 1,
  n_cores = max(c(1, parallel::detectCores()/2 - 1))
)
}
\arguments{
\item{las}{lidR las object with the segmented trees}

\item{slice_min}{the minimum height of a DBH slice}

\item{slice_max}{the maximum height of a DBH slice}

\item{max_dbh}{the maximum DBH allowed}

\item{n_cores}{number of cores to use}
}
\value{
a data.frame with the TreeID, X, Y, DBH, quality_flag, Height and ConvexHullArea
}
\description{
Function to perform a forest inventory based on a segmented las object (needs to contain TreeID)
This version is a faster but more simplistic approach than forest_inventory() for the DBH estimates
}
