\name{The alpha-transformation}
\alias{alfa}
\title{
The \eqn{\alpha}-transformation
}

\description{
The \eqn{\alpha}-transformation.
}

\usage{
alfa(x, a)
}

\arguments{
\item{x}{
A matrix with the compositional data.
}
\item{a}{
The value of the power transformation, it has to be between -1 and 1. If zero values are present it has to
be greater than 0. If \eqn{\alpha=0} the isometric log-ratio transformation is applied.
}
}

\details{
The \eqn{\alpha}-transformation is applied to the compositional data.
}

\value{
The \eqn{\alpha}-transformed data.
}

\references{
Tsagris M.T., Preston S. and Wood A.T.A. (2011). A data-based power transformation for compositional data. In Proceedings of the 4th Compositional Data Analysis Workshop, Girona, Spain.
https://arxiv.org/pdf/1106.1451.pdf
}

\author{
Michail Tsagris.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{alfa.kmeans}
}
}

\examples{
y <- as.matrix(iris[, 1:4])
y <- y / rowSums(y)
ya <- alfa(y, 0.2)
}

