
dent<-function(x,mu,sigma2,nu){
  z<-(x-mu)/sqrt(sigma2)
  return(1/sqrt(sigma2)*dt(x = z,df = nu))
}


pent<-function(x,mu,sigma2,nu){
  return(pt((x-mu)/sqrt(sigma2),nu))
}

acumt2 = function(a = NULL, b, mu, Sigma, nu) {
  Sigma21 = c(Sigma[-1, -1] - Sigma[-1, 1] %*% solve(Sigma[1, 1]) %*% Sigma[1, -1])
  expab = function(x, y) {
    delta1 = c((x - mu[1])^2 / Sigma[1, 1])
    mu21 = mu[-1] + Sigma[-1, 1] %*% solve(Sigma[1, 1]) %*% (x - mu[1])
    return(pent(y, mu21, Sigma21 * (nu + delta1) / (nu + 1), nu + 1))
  }
  func = function(x, val) {
    val * dent(x, mu[1], Sigma[1, 1], nu)
  }

  integrar_seguro = function(lower, upper, val_func) {
    tryCatch(
      {
        integrate(f = function(x) func(x, val_func(x)), lower = lower, upper = upper)$value
      },
      error = function(e) {
        cubature::cubintegrate(f = function(x) func(x, val_func(x)), lower = lower, upper = upper, method = "pcubature")$integral
      }
    )
  }

  if (all(is.infinite(a)) | is.null(a)) {
    return(integrar_seguro(-Inf, b[1], function(x) expab(x, b[2])))
  } else {
    return(
      integrar_seguro(a[1], b[1], function(x) expab(x, b[2])) -
        integrar_seguro(a[1], b[1], function(x) expab(x, a[2]))
    )
  }
}

