% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{summary_tsne_centralities}
\alias{summary_tsne_centralities}
\title{Summarize t-Distributed Stochastic Neighbor Embedding (t-SNE) on centrality measures}
\usage{
summary_tsne_centralities(x, dims = 2, perplexity = 5, scale = TRUE)
}
\arguments{
\item{x}{A list containing the computed centrality values.}

\item{dims}{An integer specifying the number of output dimensions (default = 2).}

\item{perplexity}{A numeric value representing a flexible measure of the efficient number of neighbors.
The performance of t-SNE is fairly robust to changes in perplexity, and typical values are between 5 and 50 (default = 5).}

\item{scale}{A logical value indicating whether the centrality values should be scaled or not (default = TRUE).}
}
\value{
A list containing the following elements:
- "Y": A matrix containing the new representations for the objects after t-SNE.
- "costs": The cost for every object after the final iteration of t-SNE.
The "costs" provide information about the optimization process.
}
\description{
This function summarizes the t-SNE analysis results on centrality measures.
}
\seealso{
\code{\link[Rtsne]{Rtsne}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
