% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{giant_component_extract}
\alias{giant_component_extract}
\title{Giant component extraction of a graph}
\usage{
giant_component_extract(
  x,
  directed = TRUE,
  bipartite_proj = FALSE,
  num_proj = 1
)
}
\arguments{
\item{x}{An igraph or a network object.}

\item{directed}{Whether to create a directed graph. (default = TRUE)}

\item{bipartite_proj}{Whether the bipartite network must be projected or not. (default = FALSE)}

\item{num_proj}{A number indicating the specific projection to work with, especially for
bipartite graphs. (default = 1)}
}
\value{
A list containing the giant component of the input graph. The first element is an igraph object
representing the giant component, and the second element is the corresponding edgelist.
}
\description{
This function extracts the largest connected component or the giant component
of the input graph, which can be an "igraph" object or a "network" object, and converts
it to an "igraph" object. For bipartite graphs, this function can perform projection
before extracting the components.
}
\details{
This function identifies the largest component of an "igraph" or a "network" object
and returns it as a list containing the giant component as an igraph object and its
corresponding edgelist. If the input graph is bipartite and the "bipartite_proj" parameter
is set to TRUE, the function can perform projection before extracting the components. You
can specify which projection to work with using the "num_proj" parameter.
}
\examples{
# A graph with 4 vertices

data(zachary)
giant_component_extract(zachary)

}
\references{
Newman, M. (2010). Networks. Oxford University Press.
}
\seealso{
\code{\link[igraph]{induced.subgraph}}, \code{\link[igraph]{clusters}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
