% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDPP.R
\name{plotDPP}
\alias{plotDPP}
\title{Plot a DPP Object}
\usage{
plotDPP(DPP)
}
\arguments{
\item{DPP}{An object produced by the \code{DPP.analysis()} function.}
}
\value{
No return value, called for side effects.
}
\description{
Plots the posterior distributions of the response rates for the control
and experimental arms from a \code{DPP} object created by the
\code{DPP.analysis()} function.
}
\examples{
o <- DPP.analysis(Yt=39, nt=60, Yc=13, nc=30, Ych=90, nch=200, nche = 30,
                  a0c= 0.001, b0c= 0.001, a0t= 0.001, b0t= 0.001,
                  delta_threshold = 0.1, method = "Empirical Bayes",
                  theta = 0.5, eta = 1)

# Call the function using its defined name 'plotDPP'
plotDPP(DPP = o)

}
