% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EESS.R
\name{EESS}
\alias{EESS}
\title{Bayesian Hybrid Design}
\usage{
EESS(
  pc,
  nc,
  pch,
  nche,
  nch,
  a0c = 0.001,
  b0c = 0.001,
  delta_threshold = 0.1,
  method = "Empirical Bayes",
  theta = 0.5,
  eta = 1
)
}
\arguments{
\item{pc}{A scalar. Response rate for control arm in current study.}

\item{nc}{A scalar. Number of patients in control arm in current study.}

\item{pch}{A scalar. Response rate for control treatment in historical study.}

\item{nche}{A scalar. Equivalent number of patients borrowed from historical
study.}

\item{nch}{A scalar. Total number of patients in historical control.}

\item{a0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).}

\item{b0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).}

\item{delta_threshold}{A scalar. Borrow when abs(pc_hat (current study) -
pch) <= delta_threshold.}

\item{method}{A string characters. Method for dynamic borrowing, "Empirical
Bayes", "Bayesian p", "Generalized BC", "JSD". Default "Empirical Bayes".}

\item{theta}{A scalar parameter with a range of (0, 1), and applicable to
method: "Generalized BC". Default 0.5.}

\item{eta}{A scalar parameter with a range of (0, infty), and applicable to
method: "Bayesian p", "Generalized BC", "JSD". "Generalized BC" method
requires two parameters theta and eta. Default 1.}
}
\value{
The expected effective sample size.
}
\description{
This function calculates the expected effective sample size of the DPP.
}
\examples{
EESS(pc=0.3,nc=40,pch=0.3,nche=40,nch=180, a0c=0.001,b0c=0.001,
delta_threshold=0.1,method="Empirical Bayes", theta=0.5, eta=1)

}
