% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BOJ.R
\name{pivot_longer_boj}
\alias{pivot_longer_boj}
\title{Convert a BOJ data set to long format}
\usage{
pivot_longer_boj(tbl)
}
\arguments{
\item{tbl}{Tibble. A tibble data frame containing a BOJ data set (usually
obtained via \code{get_boj(item_url, auto_pivot = FALSE)}).}
}
\value{
A tibble data frame in long format.
}
\description{
Convert a BOJ data set to long format
}
\examples{
\donttest{
ds   <- get_boj_datasets()
sppi <- get_boj(ds$url[(ds$name == "sppi_q_en")], auto_pivot = FALSE)
sppi <- subset(sppi, code == "PRCS15_52S0000000_CQ")
sppi <- pivot_longer_boj(sppi)
}
}
