% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationship_qc.R
\name{check_replicates}
\alias{check_replicates}
\title{Compatibility Between Samples Genotypes}
\usage{
check_replicates(path.vcf, select_samples = NULL, verbose = TRUE)
}
\arguments{
\item{path.vcf}{A string specifying the path to the VCF file containing genotype data.}

\item{select_samples}{An optional character vector of sample names to be selected for comparison. If NULL (default), all samples in the VCF file are used.}

\item{verbose}{A logical value indicating whether to print the number of combinations tested. Default is TRUE.}
}
\value{
A data frame with four columns:
\itemize{
\item \code{sample1}: The name of the first sample in the pair.
\item \code{sample2}: The name of the second sample in the pair.
\item \code{\%_matching_genotypes}: The percentage of compatible genotypes between the two samples.
\item \code{\%_missing_genotypes}: The percentage of missing genotypes in the comparison.
}
}
\description{
This function checks the compatibility between sample genotypes in a VCF file by comparing all pairs of samples.
}
\details{
The function removes reciprocal comparisons (e.g., A vs. B and B vs. A) and self-comparisons (e.g., A vs. A) to avoid redundancy. Compatibility is calculated as the percentage of matching genotypes between two samples, excluding missing values. The percentage of missing genotypes is also reported for each pair.
}
\examples{

#Example VCF
example_vcf <- system.file("iris_DArT_VCF.vcf.gz", package = "BIGr")

# Checking for replicates
check_tab <- check_replicates(path.vcf = example_vcf, select_samples = NULL)


}
