# AlgeriAPIs - Access Algerian Data via Public APIs
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.


#' Internet Users in Algeria
#'
#' This dataset, internet_users_tbl_df, is a tibble containing the percentage of Internet users
#' in Algeria and comparative data for regional and global contexts. It tracks the percentage
#' of individuals using the Internet over time for Algeria, the Maghreb Union, the Arab World,
#' the European Union, and the World average.
#'
#' The dataset name has been kept as 'internet_users_tbl_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' AlgeriAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
#' in any way.
#'
#' @name internet_users_tbl_df
#' @format A tibble with 32 observations and 6 variables:
#' \describe{
#'   \item{Year}{Year of observation (numeric)}
#'   \item{Algeria}{Percentage of Internet users in Algeria (numeric)}
#'   \item{Maghreb_union}{Percentage of Internet users in the Maghreb Union (numeric)}
#'   \item{Arab_world}{Percentage of Internet users in the Arab World (numeric)}
#'   \item{European_Union}{Percentage of Internet users in the European Union (numeric)}
#'   \item{The_World}{Percentage of Internet users globally (numeric)}
#' }
#' @source Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/fundal/algeria-five-indicators}
#' @usage data(internet_users_tbl_df)
#' @export
load("data/internet_users_tbl_df.rda")
NULL

#' Daily Maximum and Minimum Air Temperatures for Algiers, Algeria
#'
#' This dataset, algiers_temp_df, is a data frame containing daily maximum and minimum
#' air temperature records for Algiers, Algeria. It provides a comprehensive time series
#' of temperature measurements useful for climate analysis, heatwave detection, and
#' meteorological research.
#'
#' The dataset name has been kept as 'algiers_temp_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' AlgeriAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
#' in any way.
#'
#' @name algiers_temp_df
#' @format A data frame with 16,436 observations and 3 variables:
#' \describe{
#'   \item{t}{Date of observation (Date)}
#'   \item{tMax}{Daily maximum air temperature in degrees Celsius (numeric)}
#'   \item{tMin}{Daily minimum air temperature in degrees Celsius (numeric)}
#' }
#' @source Data taken from the \pkg{heatwaveR} package version 0.5.4
#' @usage data(algiers_temp_df)
#' @export
load("data/algiers_temp_df.rda")
NULL

