% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_c_hat}
\alias{get_c_hat}
\title{get_c_hat}
\usage{
get_c_hat(b1_hat, b2_hat, A, r)
}
\arguments{
\item{b1_hat}{estimated effect size of the first phenotype across all variants}

\item{b2_hat}{estimated effect size of the second phenotype across all variants}

\item{A}{Allele frequency information}

\item{r}{phenotypic correlation between the two phenotypes}
}
\value{
the MLE of slope between two sets of effect sizes
}
\description{
ALLSPICE function: compute the slope `c` that maximize the likelihood (maximum likelihood estimate - MLE)
}
\examples{
AC <- get_ac_mat(n_var=100)
A <- get_af_mat(AC=AC, n_ind=10000)
X <- get_geno_mat(AC, n_ind=10000)
b <- get_true_beta(n_var=100, c=0.6, pi=0.5, sigma=1, null=TRUE)
Y <- get_pheno_pair(b=b, X=X, r=0.5)
b_hat <- get_beta_hat(Y=Y, X=X, A=A, n_ind=10000)
b1_hat <- matrix(b_hat[1, ], nrow = 1)
b2_hat <- matrix(b_hat[2, ], nrow = 1)
c_hat <- get_c_hat(b1_hat=b1_hat, b2_hat=b2_hat, A=A, r=0.5)
}
