% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cortools.R
\name{correlation-tools}
\alias{correlation-tools}
\alias{r2z}
\alias{z2r}
\alias{r2t}
\alias{t2r}
\alias{r2p}
\alias{rconfint}
\alias{compcorr}
\alias{print.compcorr}
\title{Correlation tools}
\usage{
r2z(r)

z2r(z)

r2t(r, n)

t2r(t, n)

r2p(r, n)

rconfint(r, n, alpha = 0.05)

compcorr(r1, r2, n1, n2)

\method{print}{compcorr}(x, ...)
}
\arguments{
\item{r, r1, r2}{a correlation value}

\item{z}{a Z-score}

\item{n, n1, n2}{sample sizes}

\item{t}{a t-score}

\item{alpha}{the significance level to use}

\item{x}{a \code{compcorr} object to print}

\item{...}{ignored}
}
\description{
Helper functions to compute important statistics from correlation coefficients.
}
\section{Functions}{
\itemize{
\item \code{r2z()}: converts correlation coefficients to z-scores

\item \code{z2r()}: converts z-scores to correlation coefficients

\item \code{r2t()}: Converts correlation coefficients to t-scores

\item \code{t2r()}: Converts t-scores to correlation coefficients

\item \code{r2p()}: Computes the two-sided p-value for a given correlation

\item \code{rconfint()}: Computes confidence intervals for one or multiple correlation coefficients

\item \code{compcorr()}: computes the significance of the difference between two correlation coefficients

\item \code{print(compcorr)}: computes the significance of the difference between two correlation coefficients

}}
\examples{
z <- r2z(.5)
r <- z2r(z)
t<-r2t(r,30)
r2p(r,30)
print(rconfint(r,30))
print(compcorr(.5,.7,20,20))
}
\seealso{
\link{cormean}
}
