% File src/library/stats/man/Tukey.Rd
% Part of the R package, https://www.R-project.org
% Copyright 1995-2018 R Core Team
% Distributed under GPL 2 or later

\name{Tukey}
\alias{Tukey}
\alias{ptukey}
\alias{qtukey}
\title{The Studentized Range Distribution}
\description{
  Distribution function of the studentized range, \eqn{R/s},
  where \eqn{R} is the range of a standard normal sample and
  \eqn{df \times s^2}{df*s^2} is independently distributed as
  chi-squared with \eqn{df} degrees of freedom, see \code{\link{pchisq}}.
}
\usage{
ptukey(q, nmeans, df, nranges = 1, lower.tail = TRUE, log.p = FALSE)
qtukey(p, nmeans, df, nranges = 1, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
  \item{q}{vector of quantiles.}
  \item{p}{vector of probabilities.}
  \item{nmeans}{sample size for range (same for each group).}
  \item{df}{degrees of freedom for \eqn{s} (see below).}
  \item{nranges}{number of \emph{groups} whose \bold{maximum} range is
    considered.}
  \item{log.p}{logical; if \code{TRUE}, probabilities
    are given as logarithms.}
  \item{lower.tail}{logical; if \code{TRUE} (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}
}
\details{
  If \eqn{n_g =}{ng =}\code{nranges} is greater than one, \eqn{R} is
  the \emph{maximum} of \eqn{n_g}{ng} groups of \code{nmeans}
  observations each.
}
\value{
  \code{ptukey} gives the cumulative distribution function, and
  \code{qtukey} its inverse, the quantile function.

  The length of the result is the maximum of the lengths of the
  numerical arguments.  The other numerical arguments are recycled
  to that length.  Only the first elements of the logical arguments
  are used.
}
\note{
  A Legendre 16-point formula is used for the integral of \code{ptukey}.
  The computations are relatively expensive, especially for
  \code{qtukey} which uses a simple secant method for finding the
  inverse of \code{ptukey}.
  \code{qtukey} will be accurate to the 4th decimal place.
}
\source{
  \code{qtukey} is in part adapted from \bibcitet{R:Odeh+Evans:1974}.
}
\references{
  \bibshow{R:Copenhaver+Holland:1988,
    R:Odeh+Evans:1974}
}
\seealso{
  \link{Distributions} for standard distributions, including
  \code{\link{pnorm}} and \code{\link{qnorm}} for the corresponding
  functions for the normal distribution.
}
\examples{
if(interactive())
  curve(ptukey(x, nm = 6, df = 5), from = -1, to = 8, n = 101)
(ptt <- ptukey(0:10, 2, df =  5))
(qtt <- qtukey(.95, 2, df =  2:11))
## The precision may be not much more than about 8 digits:
\donttest{summary(abs(.95 - ptukey(qtt, 2, df = 2:11)))}
}
\keyword{distribution}
