## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(DFBA)

## ----eval = FALSE-------------------------------------------------------------
#  G1 <- c(96.49, 96.78, 97.26, 98.85, 99.75, 100.14, 101.15, 101.39, 102.58,
#          107.22, 107.70, 113.26)
#  
#  G2 <- c(101.16, 102.09, 103.14, 104.70, 105.27, 108.22, 108.32, 108.51, 109.88,
#          110.32, 110.55, 113.42)
#  
#  set.seed(1)
#  
#  dfba_mann_whitney(E = G1,
#                    C = G2,
#                    hide_progress = TRUE)

## ----echo = FALSE-------------------------------------------------------------
G1 <- c(96.49, 96.78, 97.26, 98.85, 99.75, 100.14, 101.15, 101.39, 102.58, 
        107.22, 107.70, 113.26)
 
G2 <- c(101.16, 102.09, 103.14, 104.70, 105.27, 108.22, 108.32, 108.51, 109.88,
        110.32, 110.55, 113.42)
load("mw_ex1")
#mw_ex1

## ----eval = FALSE-------------------------------------------------------------
#  set.seed(2)
#  dfba_mann_whitney(E = G1,
#                    C = G2,
#                    hide_progress = TRUE)
#  
#  mw_ex2 <- dfba_mann_whitney(E = G1,
#                    C = G2,
#                    hide_progress = TRUE)
#  
#  

## ----echo = FALSE-------------------------------------------------------------
load("mw_ex2")
mw_ex2

## ----eval = FALSE-------------------------------------------------------------
#  plot(dfba_mann_whitney(E = G1,
#                         C = G2,
#                         hide_progress = TRUE))

## ----echo = FALSE, fig.width = 7----------------------------------------------
plot(mw_ex2)

## -----------------------------------------------------------------------------
set.seed(1)
dfba_mann_whitney(E = G1, 
                  C = G2, 
                  method = "large")


## -----------------------------------------------------------------------------
A1B1 <- c(11.541, 11.854, 11.313, 14.201, 11.333, 11.583, 11.223)

A2B1 <- c(11.210, 11.117, 12.967, 12.514, 11.232, 13.585, 11.023)

A3B1 <- c(4.762, 2.323, 5.890, 2.722, 2.499, 2.534, 2.016)

A1B2 <- c(1.500, 1.562, 1.444, 1.822, 1.802, 1.075, 1.464)

A2B2 <- c(2.663, 1.503, 1.086, 1.459, 1.296, 1.009, 3.316)

A3B2 <- c(11.067, 11.117, 10.180, 10.060, 10.664, 10.074, 10.355)

## ----echo=FALSE, fig.width=7--------------------------------------------------
yB1 <- c(mean(A1B1), mean(A2B1), mean(A3B1))

yB2 <- c(mean(A1B2), mean(A2B2), mean(A3B2))

xA <- c(1, 2, 3)

plot(xA, 
     yB1, 
     type = "o", 
     xlab = "A levels", 
     ylab = "group means", 
     main = "B1 black; B2 red", 
     ylim = c(0, 12))

lines(xA, 
      yB2, 
      type = "o", 
      col = "firebrick")

## -----------------------------------------------------------------------------
dfba_mann_whitney(E = c(A1B1, 
                        A2B1, 
                        A3B1), 
                  C = c(A1B2, 
                        A2B2, 
                        A3B2))

## -----------------------------------------------------------------------------
dfba_mann_whitney(E = c(A1B1, 
                        A2B1, 
                        A3B2), 
                  C = c(A1B2, 
                        A2B2, 
                        A3B1))

