## ----eval=FALSE---------------------------------------------------------------
# # Install the remotes package if not already installed
# install.packages("remotes")
# 
# # # Install bolt4jr
# remotes::install_github("Broccolito/bolt4jr")
# 
# library(bolt4jr)

## ----eval=FALSE---------------------------------------------------------------
# install.packages("bolt4jr")
# library(bolt4jr)

## ----eval=FALSE---------------------------------------------------------------
# usethis::edit_r_environ()

## ----eval=FALSE---------------------------------------------------------------
# setup_bolt4jr()

## ----eval=FALSE---------------------------------------------------------------
# library(bolt4jr)
# 
# # Load credentials from .Renviron
# uri = Sys.getenv("NEO4J_URI")
# user = Sys.getenv("NEO4J_USER")
# password = Sys.getenv("NEO4J_PASSWORD")
# 
# # Query nodes
# nodes = run_query(
#   uri = uri,
#   user = user,
#   password = password,
#   query = "
#   MATCH (n)-[r]-(m)
#   WHERE type(r) IN ['ISA_AiA', 'PARTOF_ApA']
#   RETURN DISTINCT elementId(n) AS node_id, n"
# )
# 
# # Convert the result to a data frame
# nodes_df = convert_df(nodes, field_names = c("node_id", "n.identifier", "n.name", "n.source"))
# head(nodes_df)

## ----eval=FALSE---------------------------------------------------------------
# # Query edges
# edges = run_query(
#   uri = uri,
#   user = username,
#   password = password,
#   query = "
#   MATCH (n)-[r]-(m)
#   WHERE type(r) IN ['ISA_AiA', 'PARTOF_ApA']
#   RETURN DISTINCT
#     elementId(r) AS edge_id,
#     elementId(startNode(r)) AS start_node_id,
#     elementId(endNode(r)) AS end_node_id,
#     r
#   LIMIT 1000"
# )
# 
# # Examine the structure of the result
# unlist(edges[[1]])
# 
# # Extract specific fields and convert to a data frame
# edges = convert_df(
#   edges,
#   field_names = c("edge_id", "start_node_id", "end_node_id")
# )
# 
# # View the resulting data frame
# head(edges)

## ----eval=FALSE---------------------------------------------------------------
# run_batch_query(
#   uri = uri,
#   user = user,
#   password = password,
#   query = "
#   MATCH (n)-[r]-(m)
#   WHERE type(r) IN ['ISA_AiA', 'PARTOF_ApA']
#   RETURN DISTINCT
#     elementId(r) AS edge_id,
#     elementId(startNode(r)) AS start_node_id,
#     elementId(endNode(r)) AS end_node_id",
#   field_names = c("edge_id", "start_node_id", "end_node_id"),
#   filename = "edges.tsv",
#   batch_size = 1000
# )

## ----eval=FALSE---------------------------------------------------------------
# run_batch_query(
#   uri = uri,
#   user = username,
#   password = password,
#   query = "
#   MATCH (n)-[r]-(m)
#   WHERE type(r) IN ['ISA_AiA', 'PARTOF_ApA']
#   RETURN DISTINCT elementId(n) AS node_id, n",
#   field_names = c("node_id", "n.identifier", "n.name", "n.source"),
#   filename = "nodes.tsv",
#   batch_size = 1000
# )

